﻿
$(function () {
    debugger;
    //Define the Global Variables across functions.
    var bingMapsKey = 'AnMPbAuzGgURbEiN9H96j4mBiJo-JPk4fqMtkmfc6NEet28pqceuyiqk_kWrFD6x';
    var dataLayer, map, infobox, searchManager, orgUrl, webAPIUrl, loadProviders, options;
    var requestType = "accounts";
    var locs = [];
    var pins = [];
    var listItems = [];
     
    //We will load the map and other fucntions once the HTML page has finished loading. 
    document.onreadystatechange = function() {
        if (document.readyState == "complete") {
            getDataParam();
        }
    }

    function getDataParam() {
                //Get the any query string parameters and load them
                //into the vals array

                var vals = new Array();
                if (location.search != "") {
                    vals = location.search.substr(1).split("&");
                    for (var i in vals) {
                        vals[i] = vals[i].replace(/\+/g, " ").split("=");
                    }
                    //look for the parameter named 'data'

                    for (var i in vals) {
                        if (vals[i][0].toLowerCase() == "data") {
                            parseDataValue(vals[i][1]);
                            
                            break;
                        }
                    }
                }
                else {
                    alert("No Providers found");
                }
            }

    function parseDataValue(datavalue) {
        if (datavalue != "") {
            var vals = new Array();
            vals = decodeURIComponent(datavalue).split("&");
            for (var i in vals) {
                vals[i] = vals[i].replace(/\+/g, " ").split("=");
            }

            //Rebuild the Options query if we are passing them in from the Data Parameters. 
            options =
                "?$select=name,address1_line1,address1_city,address1_stateorprovince,address1_postalcode,address1_country,address1_latitude,address1_longitude,ppms_geocoded&$filter=";

            for (var i in vals) {
                options += "(accountid eq " + vals[i][1] + ")"
                if (i != vals.length - 1) {
                    options += " or ";
                } else {
                    startMap();
                }
            }
        }
        else {
            startMap();
        }
    }


    function startMap() {
        
        // Load the map.
        map = new Microsoft.Maps.Map(document.getElementById('myMap'),
        {
            credentials: bingMapsKey,
            //center: new Microsoft.Maps.Location(38.890369, -77.031960),
            mapTypeId: Microsoft.Maps.MapTypeId.road,
            zoom: 12
        });

        Microsoft.Maps.loadModule('Microsoft.Maps.HeatMap');
        Microsoft.Maps.loadModule('Microsoft.Maps.Clustering');
       
        // A setting for specifying the distance units displayed. Possible values are 'km' and 'mi'.
        var distanceUnits = 'mi';

        orgUrl = window.parent.Xrm.Page.context.getClientUrl();
        webAPIUrl = "/api/data/v8.1/";

        // Create a global infobox control.
        infobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0),
        {
            visible: false,
            offset: new Microsoft.Maps.Point(0, 20),
            height: 230,
            width: 230
        });

        infobox.setMap(map);

        // Create a session key from the map to use with data source service requests.
        var sessionKey;
        map.getCredentials(function (c) {
            sessionKey = c;
        });

        // Load the Search Module for Bing Maps for doing geocoding.
        Microsoft.Maps.loadModule('Microsoft.Maps.Search',
        {
            callback: function () {
                searchManager = new Microsoft.Maps.Search.SearchManager(map);
            }
        });

        // Resize the height of the results panel based on the available space.
        $(window).resize(function () {
            $('.mapPanel').height($(window).height() - 100);
        });
        $(window).resize();


        // A simple function for displaying error messages in the app.
        function showErrorMsg(msg) {
            $('.resultsPanel').html('<span class="errorMsg">' + msg + '</span>');
        }

        //Add An on Change Event for the Map Selection box. 
        $('#mapSelection').change(function () {
            
            clearMap();
            var mapType = $("#mapSelection option:selected").val();
            
            switch (mapType) {
                case "Map":
                    var pinlayer = new Microsoft.Maps.Layer();
                    pinlayer.add(pins);
                    map.layers.insert(pinlayer);
                    break;
                case "HeatMap":
                    var heatMapLayer = new Microsoft.Maps.HeatMapLayer(locs);
                    map.layers.insert(heatMapLayer);
                    break;
                case "ClusterMap":
                    var clusterLayer = new Microsoft.Maps.ClusterLayer(pins, { gridSize: 100 });
                    map.layers.insert(clusterLayer);
                    break;
                default:

                    break;
        }
        });

        // A simple function for clearing the map and results panel.
        function clearMap() {
            map.layers.clear();
            infobox.setOptions({ visible: false });
        }

        // Formats a time in 1000 hours to hh:mm AM/PM format
        function formatTime(val) {
            var minutes = val % 100;
            var hours = Math.round(val / 100);

            if (minutes == 0) {
                minutes = '00';
            }

            if (hours > 12) {
                return (hours - 12) + ':' + minutes + 'PM';
            } else {
                return hours + ':' + minutes + 'AM';
            }
        }

        // Calculates the shortest distance between two locations on the curvature of the earth.
        function haversineDistance(loc1, loc2) {
            var degToRad = Math.PI / 180,
                lat1 = loc1.latitude * degToRad,
                lon1 = loc1.longitude * degToRad,
                lat2 = loc2.latitude * degToRad,
                lon2 = loc2.longitude * degToRad;

            var dLat = lat2 - lat1,
                dLon = lon2 - lon1,
                cordLength = Math.pow(Math.sin(dLat / 2), 2) +
                    Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dLon / 2), 2),
                centralAngle = 2 * Math.atan2(Math.sqrt(cordLength), Math.sqrt(1 - cordLength));

            var earthRadius = (distanceUnits == 'km') ? 6378.1 : 3963.1676;
            var distance = earthRadius * centralAngle;

            // Round off distance to 2 decimal place
            return Math.round(distance * 100) / 100;
        }

        findProviders();
                                     
        function findProviders() {
           
            //Generate a Request URL with options to Query CRM Web API data. 
            var number = 25;
            var request = new String();
            
            request += orgUrl + webAPIUrl + requestType + options;
            
            $.ajax({
                type: "GET",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: request,
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                    filterProviders(data, textStatus, xhr);
                },
                error: function (e) {
                    showErrorMsg(e.statusText);
                }
            });

        }


        function filterProviders(data, textStatus, xhr) {
            var providers = data.value;
                //Not doing much here now because we are just displaying the Providers that were selected in the Homepage grid. 
                //IF after applying the filters we have Providers, proceed to sorting by distance / radius. 
                //Otherwise display a message to the user. 
                if (providers.length > 0) { AddProvidersToMap(providers); }
                else { showErrorMsg('No Providers found matching the Search Criteria'); }    
        }
      
        function AddProvidersToMap(providers) {

            //Create an array to store the location metadata. 
            //var locs = [];
            // Create an array to store the HTML used to generate the list of results.
            //var listItems = [];
            //Get the actual address entered in Searchbox for generating directions. The Geocoded searchLocation give's coordinates,
            //which do not work well passed into the Bing Directions URL. 

            //var pins = [];

            //Loop through the Providers and add them to the map. 
            for (var p = 0; p < providers.length; p++) {
                //Define the Provider's Location for the map. 
                var loc = new Microsoft.Maps
                    .Location(providers[p].address1_latitude, providers[p].address1_longitude);
                // Add the location coordinate to the array of locations
                locs.push(loc);
                // Create pushpin
                var pin = new Microsoft.Maps.Pushpin(loc,
                    {
                        icon: null,
                        text: (locs.length) + ''
                    }
                );
                // Store the location result info as a property of the pushpin so we can use it later.
                pin.Metadata = providers[p];
                // Add a click event to the pushpin to display an infobox.
                Microsoft.Maps.Events.addHandler(pin,
                    'click',
                    function(e) {
                        displayInfobox(e.target);
                    });
                // Add the pushpin to the map.
                //map.entities.push(pin);
                pins.push(pin);
                

                // Create the HTML for a single list item for the result.                        
                listItems.push('<table class="listItem"><tr><td rowspan="3"><span>',
                    (locs.length),
                    '.</span></td>');
                // Store the result ID as a property of the name. This will allow us to relate the list item to the pushpin on the map.
                listItems.push('<td><a class="title" href="javascript:void(0);" rel="',
                    providers[p].accountid,
                    '">',
                    providers[p].name,
                    '</a></td>');
                //If a location was entered, we will display the distance to each provider in the list. 

                listItems
                    .push('<td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                        null,
                        '~pos.',
                        pin.Metadata.address1_latitude,
                        '_',
                        pin.Metadata.address1_longitude,
                        '_',
                        encodeURIComponent(pin.Metadata.name),
                        '">Directions</a></td></tr>');
            
                //listItems.push('<td>', results[i].ProviderPrimarySpecialty, '</td><t/tr>');
                listItems.push('<td colspan="2" class="listItem-address">',
                    providers[p].address1_line1,
                    '<br/>',
                    providers[p].address1_city,
                    ', ');
                listItems.push(providers[p].address1_stateorprovince,
                    ' ',
                    providers[p].address1_postalcode,
                    '</td></tr>');
                listItems.push('<td colspan="2"><a class="viewprofile" href="javascript:void(0);" rel="',
                    providers[p].accountid,
                    '">',
                    "View Provider Profile",
                    '</a></td>');
                                
                listItems.push('</table>');
            }

            var pinlayer = new Microsoft.Maps.Layer();
            pinlayer.add(pins);
            map.layers.insert(pinlayer);

            // Use the array of locations from the results to set the map view to show all locations.
            if (locs.length > 1) {
                map
                    .setView({
                        bounds: Microsoft.Maps.LocationRect.fromLocations(locs),
                        padding: 80
                    });
            } else {
                map.setView({ center: locs[0], zoom: 15 });
            }

            // Add the list items to the results panel.
            $('.resultsPanel').html(listItems.join(''));

            // Add a click event to the title of each list item.
            $('.title').click(function() {
                // Get the ID of the selected location
                var id = $(this).attr('rel');
                //Loop through all the pins in the data layer and find the pushpin for the location.
                var pin;
                for (var i = 0; i < pins.length; i++) {
                    pin = pins[i];
                    if (pin.Metadata.accountid != id) {
                        pin = null;
                    } else {
                        break;
                    }
                }
                // If a pin is found with a matching ID, then center the map on it and show it's infobox.
                if (pin) {
                    // Offset the centering to account for the infobox.
                    map.setView({
                        center: pin.getLocation(),
                        centerOffset: new Microsoft.Maps.Point(-70, 150),
                        zoom: 17
                    });
                    displayInfobox(pin);
                }
            });
            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)               
            });
        }
     
        // Takes a pushpin and generates the content for the infobox from the Metadata and displays the infobox.
        function displayInfobox(pin) {


            infobox.setLocation(pin.getLocation());

            var desc = ['<table>'];

            desc.push('<tr><td colspan="2">', pin.Metadata.address1_line1, '<br/>', pin.Metadata.address1_city, ', ');
            desc.push(pin.Metadata.address1_city, '<br/>', pin.Metadata.address1_postalcode, '</td></tr>');
            desc.push('<tr><td><b>Provider Specialty:</b></td><td>',
                pin.Metadata.specialty,
                //pin.Metadata.name,
                '</td></tr>');
            //desc.push('<tr><td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=~pos.', pin.Metadata.Latitude, '_', pin.Metadata.Longitude, '_', encodeURIComponent(pin.Metadata.ProviderName), '">Directions</a></td></tr>');
            desc.push('<tr><td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                null,
                '~pos.',
                pin.Metadata.address1_latitude,
                '_',
                pin.Metadata.address1_longitude,
                '_',
                encodeURIComponent(pin.Metadata.name),
                '">Directions</a></td></tr>');
            desc.push('</table>');

            infobox.setOptions({ visible: true, title: pin.Metadata.name, description: desc.join('') });
        }       
    }
});